/***********************************************************************/
/*  This file is part of the ARM Toolchain package                     */
/*  Copyright KEIL ELEKTRONIK GmbH 2011                                */
/***********************************************************************/
/*                                                                     */
/*  FlashDev.c:  Device Description for ES32F0xx Flash                 */
/*                                                                     */ 
/*          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    biyq            the first version
************************************************************************/
/***********************************************************************/
  
#ifndef   __DEBUGMODULE_H__
#define   __DEBUGMODULE_H__


/* Includes ---------------------------------------------------------------- */

#include "ald_conf.h"
#include "stdio.h"
#include "stdarg.h"

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Macro ------------------------------------------------------ */
/* macro function to send byte */
#define SEND_BYTE(X)			(UART1->TXBUF = X)
/* macro function to critize whether byte has sent over */
#define CRITICIZE_FLAG()		(UART1->RIF & (0x01 << 14))
/* macro function to clear the flag which indicates sending process over */
#define CLR_SEND_OVER_FLAG()	(UART1->ICR = 0x01 << 14)

/* Exported Functions ------------------------------------------------------ */
int Debug_Output_Init(void);
void DebugPrintf(const char *pointer, ...);


#endif	/* __DEBUGMODULE_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
